/* Auswertung von www.landesarbeitskreis.de
   Nutzung ohne Anspruch auf Support oder Gewhr fr die Richtigkeit */
   
select   stat.statart as Statistikart,
         case stat.statart
         when 'A' then 'UVG-Statistik A'
         when 'B' then 'UVG-Statistik B'
         when 'D' then 'UVG-Statistik Rckgriff'
         when 'P' then 'Statistikbogen 6'
         when 'S' then 'Standard'
         else 'Sonstiges' 
         end as Grundlage,
         stat.stkz as Statistik_Kennzeichen,
         stat.stbez1 as Bezeichnung_1,
         stat.stbez2 as Bezeichnung_2,
         
         (case when sum((case when n_stat2sach.sgnr = 1 then 1 else 0 end)) > 0 then 'X' else '' end) as SG1,
         (case when sum((case when n_stat2sach.sgnr = 2 then 1 else 0 end)) > 0 then 'X' else '' end) as SG2,
         (case when sum((case when n_stat2sach.sgnr = 3 then 1 else 0 end)) > 0 then 'X' else '' end) as SG3,
         (case when sum((case when n_stat2sach.sgnr = 4 then 1 else 0 end)) > 0 then 'X' else '' end) as SG4,
         (case when sum((case when n_stat2sach.sgnr = 5 then 1 else 0 end)) > 0 then 'X' else '' end) as SG5,
         (case when sum((case when n_stat2sach.sgnr = 6 then 1 else 0 end)) > 0 then 'X' else '' end) as SG6,
         (case when sum((case when n_stat2sach.sgnr = 7 then 1 else 0 end)) > 0 then 'X' else '' end) as SG7,
         (case when sum((case when n_stat2sach.sgnr = 8 then 1 else 0 end)) > 0 then 'X' else '' end) as SG8,
         (case when sum((case when n_stat2sach.sgnr = 9 then 1 else 0 end)) > 0 then 'X' else '' end) as SG9
                          
from     stat, n_stat2sach, sach

where    stat.lfdnr = n_stat2sach.stkz
and      n_stat2sach.sgnr = sach.sgnr

group by stat.statart,
         case stat.statart
         when 'A' then 'UVG-Statistik A'
         when 'B' then 'UVG-Statistik B'
         when 'D' then 'UVG-Statistik Rckgriff'
         when 'P' then 'Statistikbogen 6'
         when 'S' then 'Standard'
         else 'Sonstiges' 
         end,
         stat.stkz,
         stat.stbez1,
         stat.stbez2

order by stat.statart, stat.stkz

